#include "stdafx.h"
#include "win_demo.h"
#include "DialogAlarmParam.h"
#include "afxdialogex.h"
#include "sdks.h"
#include "common_struct.h"
#include "perser_json.h"
#include "pack_json.h"

extern int m_handle;
extern int m_chn_option;

IMPLEMENT_DYNAMIC(CDialogAlarmParam, CDialogEx)

CDialogAlarmParam::CDialogAlarmParam(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_DIALOG_ALARM_PARAM, pParent)
{

}

CDialogAlarmParam::~CDialogAlarmParam()
{
}

void CDialogAlarmParam::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB_ALARM_PARAM, m_alarm_param);
	DDX_Control(pDX, IDC_COMBO_ALARM_TYPE, m_alarm_type);
	DDX_Control(pDX, IDC_DATE_START, m_start_date);
	DDX_Control(pDX, IDC_TIME_START, m_start_time);
	DDX_Control(pDX, IDC_DATE_END, m_end_date);
	DDX_Control(pDX, IDC_TIME_END, m_end_time);
	DDX_Control(pDX, IDC_LIST1, m_alarm_list);
}

BOOL CDialogAlarmParam::OnInitAlarmParam()
{
	m_alarm_param.InsertItem(0, _T("Manual Alarm"));
	m_alarm_param.InsertItem(1, _T("Disk Alarm"));
	m_alarm_param.InsertItem(2, _T("I/O Alarm"));
	m_alarm_param.InsertItem(3, _T("Motion Alarm"));
	m_manaul_alarm = new CDialogManualAlarm;
	m_disk_alarm = new CDialogDiskAlarm;
	m_io_alarm = new CDialogIOAlarm;
	m_motion_alarm = new CDialogMotionAlarm;
	m_manaul_alarm->Create(IDD_DIALOG_MANUAL_ALARM, &m_alarm_param);
	m_disk_alarm->Create(IDD_DIALOG_DISK_ALARM, &m_alarm_param);
	m_io_alarm->Create(IDD_DIALOG_IO_ALARM, &m_alarm_param);
	m_motion_alarm->Create(IDD_DIALOG_MOTION_ALARM, &m_alarm_param);
	CRect tabRect;
	m_alarm_param.GetClientRect(&tabRect);
	tabRect.left += 1;
	tabRect.right -= 1;
	tabRect.top += 22;
	tabRect.bottom -= 1;
	m_manaul_alarm->MoveWindow(&tabRect);
	m_disk_alarm->MoveWindow(&tabRect);
	m_io_alarm->MoveWindow(&tabRect);
	m_motion_alarm->MoveWindow(&tabRect);
	m_manaul_alarm->ShowWindow(SW_SHOW);
	m_disk_alarm->ShowWindow(SW_HIDE);
	m_io_alarm->ShowWindow(SW_HIDE);
	m_motion_alarm->ShowWindow(SW_HIDE);
	m_alarm_type.InsertString(0, "All");
	m_alarm_type.InsertString(1, "Manual Alarm");
	m_alarm_type.InsertString(2, TEXT("Disk Alarm"));
	m_alarm_type.InsertString(3, TEXT("I/O Alarm"));
	m_alarm_type.InsertString(4, TEXT("Motion Alarm"));
	m_alarm_type.SetCurSel(0);


	DWORD dwStyle = m_alarm_list.GetExtendedStyle();
	dwStyle |= LVS_EX_FULLROWSELECT;
	dwStyle |= LVS_EX_GRIDLINES;
	m_alarm_list.SetExtendedStyle(dwStyle);
	dwStyle |= LVS_EX_FULLROWSELECT;
	m_alarm_list.ModifyStyle(LVS_ICON | LVS_SMALLICON | LVS_LIST, LVS_REPORT);

	m_alarm_list.SetExtendedStyle(LVS_EX_GRIDLINES);
	m_alarm_list.DeleteAllItems();
	m_alarm_list.InsertColumn(0, _T("Serial Number"), LVCFMT_LEFT, 80);
	m_alarm_list.InsertColumn(1, _T("Alarm Time"), LVCFMT_LEFT, 260);
	m_alarm_list.InsertColumn(2, _T("Alarm Type"), LVCFMT_LEFT, 220);
	m_alarm_list.InsertColumn(3, _T("AlarmSrc ID"), LVCFMT_LEFT, 131);
	return TRUE;
}

BEGIN_MESSAGE_MAP(CDialogAlarmParam, CDialogEx)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST1, &CDialogAlarmParam::OnLvnItemchangedList1)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_ALARM_PARAM, &CDialogAlarmParam::OnTcnSelchangeTabAlarmParam)
	ON_BN_CLICKED(IDOK, &CDialogAlarmParam::OnBnClickedOk)
END_MESSAGE_MAP()


void CDialogAlarmParam::OnLvnItemchangedList1(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	*pResult = 0;
}

void CDialogAlarmParam::OnTcnSelchangeTabAlarmParam(NMHDR *pNMHDR, LRESULT *pResult)
{
	*pResult = 0;
	switch (m_alarm_param.GetCurSel())
	{
	case 0:
		m_manaul_alarm->ShowWindow(SW_SHOW);
		m_disk_alarm->ShowWindow(SW_HIDE);
		m_io_alarm->ShowWindow(SW_HIDE);
		m_motion_alarm->ShowWindow(SW_HIDE);
		break;
	case 1:
		m_manaul_alarm->ShowWindow(SW_HIDE);
		m_disk_alarm->ShowWindow(SW_SHOW);
		m_io_alarm->ShowWindow(SW_HIDE);
		m_motion_alarm->ShowWindow(SW_HIDE);
		m_disk_alarm->OnInitDiskAlarm();
		break;
	case 2:
		m_manaul_alarm->ShowWindow(SW_HIDE);
		m_disk_alarm->ShowWindow(SW_HIDE);
		m_io_alarm->ShowWindow(SW_SHOW);
		m_motion_alarm->ShowWindow(SW_HIDE);
		m_io_alarm->OnInitIOAlarm();
		break;
	case 3:
		m_manaul_alarm->ShowWindow(SW_HIDE);
		m_disk_alarm->ShowWindow(SW_HIDE);
		m_io_alarm->ShowWindow(SW_HIDE);
		m_motion_alarm->ShowWindow(SW_SHOW);
		m_motion_alarm->OnInitMotionAlarm();
		break;
	default:break;
	}
}

static void check_alarm_type(int alarm_type, CString *alarm_name)
{
	if (MANUAL_ALARM_TYPE == alarm_type)
		alarm_name->Format(_T("Manual Alarm"));
	else if (DISK_ALARM_TYPE == alarm_type)
		alarm_name->Format(_T("Disk Alarm"));
	else if (IO_ALARM_TYPE == alarm_type)
		alarm_name->Format(_T("I/O Alarm"));
	else if (MOTION_ALARM_TYPE == alarm_type)
		alarm_name->Format(_T("Motion Alarm"));
	else
		alarm_name->Format(_T("Unknown Alarm"));
}

void CDialogAlarmParam::OnBnClickedOk()
{
	char *p_result = NULL;
	char start_time[24] = { 0 };
	char end_time[24] = { 0 };
	CTime tm;
	int nRow = 0;
	int j = 0;
	CString strtemp;
	m_start_date.GetTime(tm);
	CString strDate = tm.Format("%Y-%m-%d");
	m_start_time.GetTime(tm);
	CString strTime = tm.Format("%H:%M:%S");
	memset(&start_time, 0, sizeof(start_time));
	sprintf(start_time, "%s %s", strDate.GetBuffer(strDate.GetLength() + 1), strTime.GetBuffer(strTime.GetLength() + 1));
	m_end_date.GetTime(tm);
	strDate = tm.Format("%Y-%m-%d");
	m_end_time.GetTime(tm);
	strTime = tm.Format("%H:%M:%S");
	memset(&end_time, 0, sizeof(end_time));
	sprintf(end_time, "%s %s", strDate.GetBuffer(strDate.GetLength() + 1), strTime.GetBuffer(strTime.GetLength() + 1));
	int max_query_times = (1024 / 60);
	jy_dev_all_alarm_list_t stAlarmInfo = { 0 };
	memset(&stAlarmInfo, 0, sizeof(jy_dev_all_alarm_list_t));
	for (int i = 0; i < max_query_times; ++i)
	{
		int nRet = sdks_dev_get_alarm_list(m_handle, m_chn_option, start_time, end_time, &p_result);
		if (!nRet)
		{
			json_parser_alarm_info_list(p_result, &stAlarmInfo, i);
			if (stAlarmInfo.is_more)
			{
				int last_num = ((i + 1) * 59);
				strncpy(start_time, stAlarmInfo.alarm_info_list[last_num].alarm_time, 24);
				Sleep(1000);
			}
			else
			{
				break;
			}
		}
		else
		{
			break;
		}
	}

	m_alarm_list.DeleteAllItems();
	int tmp_index = m_alarm_type.GetCurSel();
	for (int i = 0; i < stAlarmInfo.num; ++i)
	{
		if (0 == tmp_index)
		{
			strtemp.Format(_T("%d"), i + 1);
			nRow = m_alarm_list.InsertItem(i, strtemp);
			m_alarm_list.SetItemText(nRow, 1, stAlarmInfo.alarm_info_list[i].alarm_time);
			check_alarm_type(stAlarmInfo.alarm_info_list[i].alarm_type, &strtemp);
			m_alarm_list.SetItemText(nRow, 2, strtemp);
			strtemp.Format(_T("%d"), stAlarmInfo.alarm_info_list[i].src_id);
			m_alarm_list.SetItemText(nRow, 3, strtemp);
		}
		else 
		{
			if (stAlarmInfo.alarm_info_list[i].alarm_type == tmp_index)
			{
				strtemp.Format(_T("%d"), j + 1);
				nRow = m_alarm_list.InsertItem(j, strtemp);
				m_alarm_list.SetItemText(nRow, 1, stAlarmInfo.alarm_info_list[i].alarm_time);
				check_alarm_type(stAlarmInfo.alarm_info_list[i].alarm_type, &strtemp);
				m_alarm_list.SetItemText(nRow, 2, strtemp);
				strtemp.Format(_T("%d"), stAlarmInfo.alarm_info_list[i].src_id);
				m_alarm_list.SetItemText(nRow, 3, strtemp);
				++j;
			}
		}
	}
}
